def read_queries(queries):
    reads = [k for k in queries.keys() if k.strip().startswith("SELECT")]
    
    data = {}
    for q in reads:
        data[q] = queries[q]

    return data

def write_queries(queries):
    writes = [k for k in queries.keys() if k.strip().startswith("INSERT") or \
                  k.strip().startswith("UPDATE") or \
                  k.strip().startswith("DELETE") or \
                  k.strip().startswith("BEGIN") or \
                  k.strip().startswith("COMMIT")]
    
    data = {}
    for q in writes:
        data[q] = queries[q]

    return data

def overhead_queries(queries):
    overs = [k for k in queries.keys() if not k.strip().startswith("SELECT") and \
                 not k.strip().startswith("INSERT") and \
                 not k.strip().startswith("UPDATE") and \
                 not k.strip().startswith("DELETE") and \
                 not k.strip().startswith("BEGIN") and \
                 not k.strip().startswith("COMMIT")]

    data = {}
    for q in overs:
        data[q] = queries[q]
    
    return data

def total_queries(queries):
    return sum([len(queries[k]) for k in queries.keys()])

def total_time(queries):
    return sum(map(lambda x:sum(apply(zip, x)[1]), queries.values()))

def rep_read_write_over(queries):
    reads = read_queries(queries)
    totread = total_queries(reads)
    timeread = total_time(reads)

    writes = write_queries(queries)
    totwrite = total_queries(writes)
    timewrite = total_time(writes)

    overs = overhead_queries(queries)
    totover = total_queries(overs)
    timeover = total_time(overs)

    tot = totread + totwrite + totover
    timetot = timeread + timewrite + timeover

    print "read \t\t %8dq %0.2f%% \t %8.2fm \t %0.2f%%" % \
        (totread,
         totread * 100.0 / tot, 
         timeread / 60000,
         timeread * 100.0 / timetot)
    print "write \t\t %8dq %0.2f%% \t %8.2fm \t %0.2f%%" % \
        (totwrite,
         totwrite * 100.0 / tot, 
         timewrite / 60000,
         timewrite * 100.0 / timetot)
    print "overhead \t %8dq %0.2f%% \t %8.2fm \t %0.2f%%" % \
        (totover,
         totover * 100.0 / tot, 
         timeover / 60000,
         timeover * 100.0 / timetot)


def users(queries):
    names = []
    for g in queries.keys():
        for user, dur in queries[g]:
            if user not in names:
                names.append(user)
    return names

def user_queries(queries, user):
    data = {}
    for g in queries:
        data[g] = filter(lambda x: x[0] == user, queries[g])
        if len(data[g]) == 0:
            del data[g]
    return data

def rep_freq(queries, num=10):
    data = {}
    tot_q = total_queries(queries)
    for g in queries:
        tot = len(queries[g])
        tot_pct = tot * 100.0 / tot_q

        data[g] = (tot, tot_pct)
    
    keys = sorted(data.keys(), lambda x,y:cmp(data[x][0],data[y][0]), reverse=True)[:num]
    for k in keys:
        print "%6.2f %d %s" % (data[k][1], data[k][0], k)

def rep_time(queries, num=10):
    data = {}
    tot_q = total_queries(queries)
    tot_t = total_time(queries)

    for g in queries:
        tot = len(queries[g])
        timetot = sum(map(lambda x:x[1], queries[g]))
        tot_pct = tot * 100.0 / tot_q
        timetot_pct = timetot * 100.0 / tot_t

        data[g] = (timetot, timetot_pct, tot, tot_pct)

    keys = sorted(data.keys(), lambda x,y:cmp(data[x][0],data[y][0]), 
                  reverse=True)[:num]
    for k in keys:
        print "%6.2f%% %8.2fm %6.2f%% %8dq %s" % (data[k][1], 
                                                  data[k][0] / 60000, 
                                                  data[k][3],
                                                  data[k][2],
                                                  k)

def rep_users(queries):
    for u in users(queries):
        print u.upper()
        rep_read_write_over(user_queries(queries, u))
